﻿close
clear 
clc 

//This is program calculates the energy eigen vaules and eigen functions 
//for a particle in an infinite potential well of width a


// declaring constant values
m = 9.1e-31;  // mass of electron
hplanck= 6.63*1e-34  // value of plancks constant
hbar = hplanck/(2*%pi)    // value of h/2*pi (let we call it hbar)
hbarsqbytwo_m_term = (hbar^2)/(2*m);  //(value of hbar square by 2*m)
eV = 1.6e-19; //   vale of electron volt si units
MeV = (1e+6)*eV; // writing Mega elctron volt
Angst = 1e-10;   // value of one angstrom

x_min = 0; 
x_max = 1*Angst; //This value can be changed to change width of 1D box

disp ('The box size is (in meters):' )
disp(x_max)

N = input("Input the number of intervals (should be around 500 to 1000 for good computation)")
a = (x_max-x_min);   // width of 1 d box
s = (x_max-x_min)/N;   // step size 
fac = -hbarsqbytwo_m_term/(s^2);    // this factor is (hbar^2/2m) divided by h^2 

// making a row vector to input x values 
for i=1:1:N 
    x(1,i)=x_min+(i-1)*s
end 
// Kinetic energy matrix (Using central difference formula)
T=zeros(N,N) 
for i=1:1:N 
    T(i,i)=-2; 
    if (i<N) 
        T(i,i+1)=1; 
        T(i+1,i)=1 
    end 
end 
T_matrix = fac*T/eV; // Kinetic Energy Matrix in eV 

// potential energy matrix 
U_matrix = zeros(N,N) 
for i = 1:1:N    
U_matrix(i,i)=0; 
end 

// Hamiltonian matrix H=U+T
H_matrix = T_matrix+U_matrix; 
[u,eigen] = spec(H_matrix); 
eigval_numeric = spec(H_matrix) 

// normalisation check 
normalisation = sum((u(:,1).*conj(u(:,1)))) 

// By theoretically achieved Formulae 
for n= 1:1:5 
eigval_theory = (n^2*%pi^2*hbar^2)/(2*m*a^2)  // in SI units 
eigval_th_eV(n) = eigval_theory/eV   // in eV 
end 

disp('The Eigen (eV) values obtained from Finite difference method are :')
disp(eigval_numeric(1:5))
disp('The Eigen values (eV) obtained from Analytic Formula are :')
disp(eigval_th_eV(1:5))

//Plotting the eigenvalues 
figure; 
for n =1:1:5
    temp1 = eigval_numeric(n) 
    eigval_numeric_vector = temp1*ones(1,N); 
    plot(x/Angst,eigval_numeric_vector,'r--', 'linewidth', 2) 
    xlabel('x (in angstrom units)','fontsize',3)
    ylabel('Eigenvalue (eV)','fontsize',3)
    title('Eigenvalues for first 5 Eigen functions','fontsize',3)
end 


// plotting the Probbility functions. (plot of mod psi squared)

figure; 
for in =1:1:5
psisq(:,in) = (u(:,in).*conj(u(:,in))) 
end

subplot(5,1,1) 
title('First five Probability density functions','fontsize',3)
plot(x(1,:)/Angst,psisq(:,1)','r','linewidth',2) 
subplot(5,1,2) 
plot(x(1,:)/Angst,psisq(:,2)','r','linewidth',  2) 
subplot(5,1,3) 
plot(x(1,:)/Angst,psisq(:,3)','r','linewidth', 2) 
ylabel("Probability density",'fontsize',3)
subplot(5,1,4) 
plot(x(1,:)/Angst,psisq(:,4)','r','linewidth', 2) 
subplot(5,1,5) 
plot(x(1,:)/Angst,psisq(:,5)','r','linewidth', 2) 
xlabel("x (in angstrom units)",'fontsize',3)

